/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.TowingConnection;
import minecrafttransportsimulator.entities.components.AEntityG_Towable;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketEntityTowingChange
extends APacketEntity<AEntityG_Towable<?>> {
    private final int connectionIndex;
    private final IWrapperNBT connectionData;

    public PacketEntityTowingChange(AEntityG_Towable<?> hitchEntity, TowingConnection connection) {
        super(hitchEntity);
        this.connectionIndex = -1;
        this.connectionData = connection.save(InterfaceManager.coreInterface.getNewNBTWrapper());
    }

    public PacketEntityTowingChange(AEntityG_Towable<?> hitchEntity, int connectionIndex) {
        super(hitchEntity);
        this.connectionIndex = connectionIndex;
        this.connectionData = null;
    }

    public PacketEntityTowingChange(ByteBuf buf) {
        super(buf);
        this.connectionIndex = buf.readInt();
        this.connectionData = this.connectionIndex == -1 ? PacketEntityTowingChange.readDataFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.connectionIndex);
        if (this.connectionData != null) {
            PacketEntityTowingChange.writeDataToBuffer(this.connectionData, buf);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handle(AWrapperWorld world, AEntityG_Towable<?> hitchEntity) {
        if (this.connectionIndex == -1) {
            TowingConnection connection = new TowingConnection(this.connectionData);
            if (!connection.initConnection(world, false)) return false;
            hitchEntity.connectTrailer(connection, false);
            return true;
        } else {
            hitchEntity.disconnectTrailer(this.connectionIndex);
        }
        return true;
    }
}

